<?xml version="1.0" encoding="UTF-8"?>
<xsl:transform xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>
		<xsl:template match="Accident[@primitive='Point' and sARAmongTypesOfAccidents='true']" priority="4">			
			<pointInstruction>
				<featureReference>
					<xsl:value-of select="@id"/>
				</featureReference>
				<viewingGroup>40212</viewingGroup>
				<displayPlane>OVERRADAR</displayPlane>
				<drawingPriority>99</drawingPriority>
				<xsl:element name="symbol">
					<xsl:attribute name="reference">SAR1</xsl:attribute> 
				</xsl:element>
			</pointInstruction>
		</xsl:template>
		<xsl:template match="Accident[@primitive='Point' and medicalAssistanceAmongTypesOfAccidents='true']" priority="3">
			<pointInstruction>
				<featureReference>
					<xsl:value-of select="@id"/>
				</featureReference>
				<viewingGroup>40212</viewingGroup>
				<displayPlane>OVERRADAR</displayPlane>
				<drawingPriority>99</drawingPriority>
				<xsl:element name="symbol">
					<xsl:attribute name="reference">MedicalAssistance</xsl:attribute> 
				</xsl:element>
			</pointInstruction>     
		</xsl:template>
		<xsl:template match="Accident[@primitive='Point' and nUCAmongTypesOfAccidents='true']" priority="2">
			<pointInstruction>
				<featureReference>
					<xsl:value-of select="@id"/>
				</featureReference>
				<viewingGroup>40212</viewingGroup>
				<displayPlane>OVERRADAR</displayPlane>
				<drawingPriority>99</drawingPriority>
				<xsl:element name="symbol">
					<xsl:attribute name="reference">NUC1</xsl:attribute> 
				</xsl:element>
			</pointInstruction>     
		</xsl:template>
		<xsl:template match="Accident[@primitive='Point']" priority="1">
			<nullInstruction>
				<featureReference>
					<xsl:value-of select="@id"/>
				</featureReference>
				<viewingGroup>0</viewingGroup>
				<displayPlane>UNDERRADAR</displayPlane>
				<drawingPriority>0</drawingPriority>
			</nullInstruction>     
		</xsl:template>
</xsl:transform>
