<?xml version="1.0" encoding="UTF-8"?>
<xsl:transform xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>
		<xsl:template match="SendingAccidentInformationVTSArea[@primitive='Point' and accidentAlarmType=1]" priority="9">			
			<pointInstruction>
				<featureReference>
					<xsl:value-of select="@id"/>
				</featureReference>
				<viewingGroup>40212</viewingGroup>
				<displayPlane>OVERRADAR</displayPlane>
				<drawingPriority>99</drawingPriority>
				<xsl:element name="symbol">
					<xsl:attribute name="reference">SAR2</xsl:attribute> 
				</xsl:element>
			</pointInstruction>
		</xsl:template>
		<xsl:template match="SendingAccidentInformationVTSArea[@primitive='Point' and accidentAlarmType=2]" priority="8">			
			<pointInstruction>
				<featureReference>
					<xsl:value-of select="@id"/>
				</featureReference>
				<viewingGroup>40212</viewingGroup>
				<displayPlane>OVERRADAR</displayPlane>
				<drawingPriority>99</drawingPriority>
				<xsl:element name="symbol">
					<xsl:attribute name="reference">NUC2</xsl:attribute> 
				</xsl:element>
			</pointInstruction>
		</xsl:template>
		<xsl:template match="SendingAccidentInformationVTSArea[@primitive='Point' and accidentAlarmType=3]" priority="7">			
			<pointInstruction>
				<featureReference>
					<xsl:value-of select="@id"/>
				</featureReference>
				<viewingGroup>40212</viewingGroup>
				<displayPlane>OVERRADAR</displayPlane>
				<drawingPriority>99</drawingPriority>
				<xsl:element name="symbol">
					<xsl:attribute name="reference">Traffic1</xsl:attribute> 
				</xsl:element>
			</pointInstruction>
		</xsl:template>		
		<xsl:template match="SendingAccidentInformationVTSArea[@primitive='Surface' and accidentAlarmType=1]" priority="6">			
			<lineInstruction>
				<featureReference>
					<xsl:value-of select="@id"/>
				</featureReference>
				<viewingGroup>40212</viewingGroup>
				<displayPlane>OVERRADAR</displayPlane>
				<drawingPriority>90</drawingPriority>
				<lineStyleReference reference="VTSMARK2"/>
			</lineInstruction>
			<pointInstruction>
			    <featureReference>
					<xsl:value-of select="@id"/>
			    </featureReference>
			    <viewingGroup>40212</viewingGroup>
			    <displayPlane>OVERRADAR</displayPlane>
			    <drawingPriority>90</drawingPriority>
				<symbol reference="SAR3">
					<areaPlacement placementMode="VisibleParts"/>
				</symbol>
			</pointInstruction>
		</xsl:template>
		<xsl:template match="SendingAccidentInformationVTSArea[@primitive='Surface' and accidentAlarmType=3]" priority="5">			
			<lineInstruction>
				<featureReference>
					<xsl:value-of select="@id"/>
				</featureReference>
				<viewingGroup>40212</viewingGroup>
				<displayPlane>OVERRADAR</displayPlane>
				<drawingPriority>90</drawingPriority>
				<lineStyleReference reference="VTSMARK2"/>
			</lineInstruction>
			<pointInstruction>
			    <featureReference>
					<xsl:value-of select="@id"/>
			    </featureReference>
			    <viewingGroup>40212</viewingGroup>
			    <displayPlane>OVERRADAR</displayPlane>
			    <drawingPriority>90</drawingPriority>
				<symbol reference="Traffic2">
					<areaPlacement placementMode="VisibleParts"/>
				</symbol>
			</pointInstruction>
		</xsl:template>
		<xsl:template match="SendingAccidentInformationVTSArea[@primitive='Point']" priority="2">			
			<nullInstruction>
				<featureReference>
					<xsl:value-of select="@id"/>
				</featureReference>
				<viewingGroup>0</viewingGroup>
				<displayPlane>UNDERRADAR</displayPlane>
				<drawingPriority>0</drawingPriority>
			</nullInstruction>
		</xsl:template>
		<xsl:template match="SendingAccidentInformationVTSArea[@primitive='Surface']" priority="1">			
			<nullInstruction>
				<featureReference>
					<xsl:value-of select="@id"/>
				</featureReference>
				<viewingGroup>0</viewingGroup>
				<displayPlane>UNDERRADAR</displayPlane>
				<drawingPriority>0</drawingPriority>
			</nullInstruction>
		</xsl:template>
</xsl:transform>
