<?xml version="1.0" encoding="UTF-8"?>

<xsl:transform xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
   <xsl:output method="xml" encoding="UTF-8" indent="yes"/>
   <xsl:template match="*[@primitive='Curve']">
      <lineInstruction>
         <featureReference>
            <xsl:value-of select="@id"/>
         </featureReference>
         <viewingGroup>40212</viewingGroup>
         <displayPlane>OVERRADAR</displayPlane>
         <drawingPriority>90</drawingPriority>
         <lineStyleReference reference="212QUESMRK1"/>
      </lineInstruction>
   </xsl:template>
   <xsl:template match="*[@primitive='Point']">
      <pointInstruction>
         <featureReference>
            <xsl:value-of select="@id"/>
         </featureReference>
         <viewingGroup>40212</viewingGroup>
         <displayPlane>OVERRADAR</displayPlane>
         <drawingPriority>99</drawingPriority>
         <symbol reference="QUESMRK1"/>
      </pointInstruction>
   </xsl:template>
  <xsl:template match="*[@primitive='Surface']">
    <pointInstruction>
      <featureReference>
        <xsl:value-of select="@id"/>
      </featureReference>
      <viewingGroup>40212</viewingGroup>
      <displayPlane>UNDERRADAR</displayPlane>
      <drawingPriority>90</drawingPriority>
      <symbol reference="QUESMRK1">
        <areaPlacement placementMode="VisibleParts"/>
      </symbol>
    </pointInstruction>
    <lineInstruction>
         <featureReference>
            <xsl:value-of select="@id"/>
         </featureReference>
         <viewingGroup>40212</viewingGroup>
         <displayPlane>UNDERRADAR</displayPlane>
         <drawingPriority>90</drawingPriority>
         <lineStyleReference reference="212QUESMRK1"/>
      </lineInstruction>
  </xsl:template>
</xsl:transform>
